package gov.va.vamf.scheduling.direct.resource;

import gov.va.vamf.scheduling.direct.datalayer.facility.CustomMessageService;
import gov.va.vamf.scheduling.direct.domain.CustomMessage;
import gov.va.vamf.security.v1.filters.JwtRbacRestricted;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import java.util.List;

@Path("/custom-messages")
@Component
public class CustomMessageResource {
    @Resource
    private CustomMessageService customMessageService;

    /**
     * Get custom messages for a given institution and, optionally, specific message types.
     * @param institutionCode retrieve custom messages for this institution
     * @param types the specific types of messages sought, corresponding to the "messageId" field of CustomMessage
     * @return custom messages matching the specified institution and types
     */
    @GET
    @JwtRbacRestricted("Veteran")
    @Produces({MediaType.APPLICATION_JSON})
    public List<CustomMessage> getCustomMessages(
            @NotNull @QueryParam("institution-code") final String institutionCode,
            @QueryParam("type") final List<String> types
    ) {
        return customMessageService.fetchCustomMessagesBySiteCodeAndMessageIds(institutionCode, types);
    }
}